import type { FC } from "react"

interface LogoProps {
  className?: string
  size?: "sm" | "md" | "lg"
}

const Logo: FC<LogoProps> = ({ className = "", size = "md" }) => {
  const sizeClasses = {
    sm: "h-8 w-auto",
    md: "h-10 w-auto",
    lg: "h-16 w-auto",
  }

  return (
    <div className={`relative ${sizeClasses[size]} ${className}`}>
      <svg viewBox="0 0 200 60" fill="none" xmlns="http://www.w3.org/2000/svg" className="h-full w-auto">
        <defs>
          <linearGradient id="logoGradient" x1="0%" y1="0%" x2="100%" y2="100%">
            <stop offset="0%" stopColor="#4338ca" />
            <stop offset="50%" stopColor="#7e22ce" />
            <stop offset="100%" stopColor="#9333ea" />
          </linearGradient>
        </defs>

        {/* Hexagon background */}
        <path d="M30 10L50 20V40L30 50L10 40V20L30 10Z" fill="url(#logoGradient)" className="drop-shadow-lg" />

        {/* Alpha symbol */}
        <path
          d="M25 20L30 35L35 20M23 30H37"
          stroke="white"
          strokeWidth="2.5"
          strokeLinecap="round"
          strokeLinejoin="round"
        />

        {/* Number 3 */}
        <path
          d="M40 25C42 25 44 26 44 28C44 30 42 31 40 31C42 31 44 32 44 34C44 36 42 37 40 37"
          stroke="white"
          strokeWidth="2.5"
          strokeLinecap="round"
          strokeLinejoin="round"
        />

        {/* Text */}
        <text x="60" y="35" fontFamily="Arial" fontWeight="bold" fontSize="18" fill="currentColor">
          Alpha3 Solution
        </text>
      </svg>
    </div>
  )
}

export default Logo

