import Image from "next/image"
import Link from "next/link"
import { ArrowRight, Code, Server, Globe, Database, Shield, Smartphone } from "lucide-react"

export default function TechnologyServicesPage() {
  return (
    <>
      {/* Hero Section */}
      <section className="pt-32 pb-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(67,56,202,0.15),transparent_40%)]"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-3xl">
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold mb-6">
              Advanced <span className="gradient-text">Technology Solutions</span> for Modern Businesses
            </h1>
            <p className="text-xl text-foreground/80 mb-8 max-w-2xl">
              End-to-end technology services that empower businesses to stay ahead in the digital transformation
              journey.
            </p>
            <Link
              href="/contact"
              className="px-6 py-3 rounded-full bg-gradient-to-r from-primary via-secondary to-accent text-white font-medium hover:shadow-lg transition-all inline-flex items-center"
            >
              Get Started <ArrowRight className="ml-2 h-5 w-5" />
            </Link>
          </div>
        </div>
      </section>

      {/* Services Grid */}
      <section className="py-20 bg-background">
        <div className="container mx-auto px-4">
          <div className="text-center max-w-3xl mx-auto mb-16">
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Our Technology Services</h2>
            <p className="text-lg text-foreground/80">
              Comprehensive technology solutions tailored to meet the evolving needs of modern businesses
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {/* Custom Software Development */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-primary/10 flex items-center justify-center mb-6 group-hover:bg-primary/20 transition-colors">
                <Code className="h-7 w-7 text-primary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Custom Software Development</h3>
              <p className="text-foreground/70 mb-4">
                Tailor-made software solutions designed to address your specific business challenges and requirements.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Enterprise Applications
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  SaaS Solutions
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  API Development & Integration
                </li>
              </ul>
              <Link
                href="/services/technology/custom-software"
                className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Web Development */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-secondary/10 flex items-center justify-center mb-6 group-hover:bg-secondary/20 transition-colors">
                <Globe className="h-7 w-7 text-secondary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Web Development</h3>
              <p className="text-foreground/70 mb-4">
                Responsive, high-performance websites and web applications that deliver exceptional user experiences.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Corporate Websites
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  E-commerce Platforms
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Progressive Web Apps
                </li>
              </ul>
              <Link
                href="/services/technology/web-development"
                className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Mobile App Development */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-accent/10 flex items-center justify-center mb-6 group-hover:bg-accent/20 transition-colors">
                <Smartphone className="h-7 w-7 text-accent" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Mobile App Development</h3>
              <p className="text-foreground/70 mb-4">
                Native and cross-platform mobile applications that engage users and drive business growth.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  iOS & Android Apps
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Cross-Platform Development
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Mobile Strategy & UX Design
                </li>
              </ul>
              <Link
                href="/services/technology/mobile-development"
                className="inline-flex items-center text-accent hover:text-accent/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Cloud Services */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-primary/10 flex items-center justify-center mb-6 group-hover:bg-primary/20 transition-colors">
                <Server className="h-7 w-7 text-primary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Cloud Services</h3>
              <p className="text-foreground/70 mb-4">
                Scalable, secure, and cost-effective cloud solutions to modernize your IT infrastructure.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Cloud Migration
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Infrastructure as a Service (IaaS)
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  DevOps & CI/CD
                </li>
              </ul>
              <Link
                href="/services/technology/cloud-services"
                className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Data & Analytics */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-secondary/10 flex items-center justify-center mb-6 group-hover:bg-secondary/20 transition-colors">
                <Database className="h-7 w-7 text-secondary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Data & Analytics</h3>
              <p className="text-foreground/70 mb-4">
                Transform raw data into actionable insights to drive informed business decisions.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Data Warehousing
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Business Intelligence
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Big Data Processing
                </li>
              </ul>
              <Link
                href="/services/technology/data-analytics"
                className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Cybersecurity */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-accent/10 flex items-center justify-center mb-6 group-hover:bg-accent/20 transition-colors">
                <Shield className="h-7 w-7 text-accent" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Cybersecurity</h3>
              <p className="text-foreground/70 mb-4">
                Protect your digital assets with comprehensive security solutions and best practices.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Security Assessment
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Threat Detection & Response
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Compliance & Governance
                </li>
              </ul>
              <Link
                href="/services/technology/cybersecurity"
                className="inline-flex items-center text-accent hover:text-accent/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>
          </div>
        </div>
      </section>

      {/* Case Study Section */}
      <section className="py-20 bg-gradient-to-b from-background to-background/95">
        <div className="container mx-auto px-4">
          <div className="text-center max-w-3xl mx-auto mb-16">
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Success Stories</h2>
            <p className="text-lg text-foreground/80">
              See how our technology solutions have transformed businesses across industries
            </p>
          </div>

          <div className="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=800"
                  alt="E-commerce Platform Case Study"
                  fill
                  className="object-cover"
                />
              </div>
              <div className="p-6">
                <div className="inline-block px-3 py-1 rounded-full bg-secondary/10 text-secondary text-sm font-medium mb-4">
                  Web Development
                </div>
                <h3 className="text-xl font-semibold mb-3">E-commerce Platform Overhaul</h3>
                <p className="text-foreground/70 mb-4">
                  How we helped a retailer increase online sales by 200% with a modern, high-performance e-commerce
                  platform.
                </p>
                <Link
                  href="/case-studies/ecommerce-platform"
                  className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>

            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=800"
                  alt="Cloud Migration Case Study"
                  fill
                  className="object-cover"
                />
              </div>
              <div className="p-6">
                <div className="inline-block px-3 py-1 rounded-full bg-primary/10 text-primary text-sm font-medium mb-4">
                  Cloud Services
                </div>
                <h3 className="text-xl font-semibold mb-3">Enterprise Cloud Migration</h3>
                <p className="text-foreground/70 mb-4">
                  How our cloud migration strategy helped a manufacturing company reduce IT costs by 40% and improve
                  scalability.
                </p>
                <Link
                  href="/case-studies/cloud-migration"
                  className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>
          </div>

          <div className="text-center mt-12">
            <Link
              href="/case-studies"
              className="px-6 py-2.5 rounded-full border border-border hover:border-primary hover:text-primary transition-all inline-flex items-center"
            >
              View all case studies <ArrowRight className="ml-2 h-4 w-4" />
            </Link>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-r from-primary/10 via-secondary/10 to-accent/10"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <h2 className="text-3xl md:text-4xl font-bold mb-6">Ready to Transform Your Technology Infrastructure?</h2>
            <p className="text-lg text-foreground/80 mb-8 max-w-2xl mx-auto">
              Schedule a consultation with our technology experts to discuss how our solutions can address your specific
              business challenges.
            </p>
            <Link
              href="/contact"
              className="px-8 py-3 rounded-full bg-gradient-to-r from-primary via-secondary to-accent text-white font-medium hover:shadow-lg transition-all text-lg inline-block"
            >
              Get Started Today
            </Link>
          </div>
        </div>
      </section>
    </>
  )
}

