import Image from "next/image"
import Link from "next/link"
import { ArrowRight, LineChart, CreditCard, BarChart3, Wallet, Lock, Landmark } from "lucide-react"

export default function FintechServicesPage() {
  return (
    <>
      {/* Hero Section */}
      <section className="pt-32 pb-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(126,34,206,0.15),transparent_40%)]"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-3xl">
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold mb-6">
              Innovative <span className="gradient-text">Fintech Solutions</span> for Modern Finance
            </h1>
            <p className="text-xl text-foreground/80 mb-8 max-w-2xl">
              Revolutionize your financial operations with cutting-edge technology solutions designed for the digital
              economy.
            </p>
            <Link
              href="/contact"
              className="px-6 py-3 rounded-full bg-gradient-to-r from-primary via-secondary to-accent text-white font-medium hover:shadow-lg transition-all inline-flex items-center"
            >
              Get Started <ArrowRight className="ml-2 h-5 w-5" />
            </Link>
          </div>
        </div>
      </section>

      {/* Services Grid */}
      <section className="py-20 bg-background">
        <div className="container mx-auto px-4">
          <div className="text-center max-w-3xl mx-auto mb-16">
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Our Fintech Services</h2>
            <p className="text-lg text-foreground/80">
              Comprehensive financial technology solutions to drive efficiency, security, and growth
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {/* Digital Banking */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-secondary/10 flex items-center justify-center mb-6 group-hover:bg-secondary/20 transition-colors">
                <Landmark className="h-7 w-7 text-secondary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Digital Banking</h3>
              <p className="text-foreground/70 mb-4">
                Modern banking platforms that provide seamless customer experiences and operational efficiency.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Mobile Banking Solutions
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Digital Onboarding
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Banking as a Service (BaaS)
                </li>
              </ul>
              <Link
                href="/services/fintech/digital-banking"
                className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Payment Solutions */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-primary/10 flex items-center justify-center mb-6 group-hover:bg-primary/20 transition-colors">
                <CreditCard className="h-7 w-7 text-primary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Payment Solutions</h3>
              <p className="text-foreground/70 mb-4">
                Secure, fast, and flexible payment processing systems for businesses of all sizes.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Payment Gateways
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Contactless Payments
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Subscription Billing
                </li>
              </ul>
              <Link
                href="/services/fintech/payment-solutions"
                className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Blockchain & Crypto */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-accent/10 flex items-center justify-center mb-6 group-hover:bg-accent/20 transition-colors">
                <Wallet className="h-7 w-7 text-accent" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Blockchain & Crypto</h3>
              <p className="text-foreground/70 mb-4">
                Leverage blockchain technology for secure, transparent, and efficient financial operations.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Smart Contracts
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Cryptocurrency Integration
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Decentralized Finance (DeFi)
                </li>
              </ul>
              <Link
                href="/services/fintech/blockchain"
                className="inline-flex items-center text-accent hover:text-accent/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Financial Analytics */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-secondary/10 flex items-center justify-center mb-6 group-hover:bg-secondary/20 transition-colors">
                <BarChart3 className="h-7 w-7 text-secondary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Financial Analytics</h3>
              <p className="text-foreground/70 mb-4">
                Data-driven insights to optimize financial performance and make informed business decisions.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Predictive Financial Modeling
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Risk Assessment
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Performance Dashboards
                </li>
              </ul>
              <Link
                href="/services/fintech/financial-analytics"
                className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Wealth Management */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-primary/10 flex items-center justify-center mb-6 group-hover:bg-primary/20 transition-colors">
                <LineChart className="h-7 w-7 text-primary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Wealth Management</h3>
              <p className="text-foreground/70 mb-4">
                Digital solutions for investment management, financial planning, and portfolio optimization.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Robo-Advisory
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Portfolio Management
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Financial Planning Tools
                </li>
              </ul>
              <Link
                href="/services/fintech/wealth-management"
                className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Cybersecurity */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-accent/10 flex items-center justify-center mb-6 group-hover:bg-accent/20 transition-colors">
                <Lock className="h-7 w-7 text-accent" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Financial Security</h3>
              <p className="text-foreground/70 mb-4">
                Protect financial data and transactions with advanced security solutions and compliance frameworks.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Fraud Prevention
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Regulatory Compliance
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Secure Authentication
                </li>
              </ul>
              <Link
                href="/services/fintech/security"
                className="inline-flex items-center text-accent hover:text-accent/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>
          </div>
        </div>
      </section>

      {/* Case Study Section */}
      <section className="py-20 bg-gradient-to-b from-background to-background/95">
        <div className="container mx-auto px-4">
          <div className="text-center max-w-3xl mx-auto mb-16">
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Success Stories</h2>
            <p className="text-lg text-foreground/80">
              See how our Fintech solutions have transformed financial operations across industries
            </p>
          </div>

          <div className="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=800"
                  alt="Digital Banking Case Study"
                  fill
                  className="object-cover"
                />
              </div>
              <div className="p-6">
                <div className="inline-block px-3 py-1 rounded-full bg-secondary/10 text-secondary text-sm font-medium mb-4">
                  Digital Banking
                </div>
                <h3 className="text-xl font-semibold mb-3">Next-Gen Mobile Banking Platform</h3>
                <p className="text-foreground/70 mb-4">
                  How we helped a traditional bank transform their digital presence and increase mobile engagement by
                  215%.
                </p>
                <Link
                  href="/case-studies/mobile-banking"
                  className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>

            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=800"
                  alt="Payment Processing Case Study"
                  fill
                  className="object-cover"
                />
              </div>
              <div className="p-6">
                <div className="inline-block px-3 py-1 rounded-full bg-primary/10 text-primary text-sm font-medium mb-4">
                  Payment Solutions
                </div>
                <h3 className="text-xl font-semibold mb-3">Global Payment Infrastructure</h3>
                <p className="text-foreground/70 mb-4">
                  How our payment solution helped an e-commerce platform reduce transaction costs by 32% and expand
                  globally.
                </p>
                <Link
                  href="/case-studies/global-payments"
                  className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>
          </div>

          <div className="text-center mt-12">
            <Link
              href="/case-studies"
              className="px-6 py-2.5 rounded-full border border-border hover:border-secondary hover:text-secondary transition-all inline-flex items-center"
            >
              View all case studies <ArrowRight className="ml-2 h-4 w-4" />
            </Link>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-r from-primary/10 via-secondary/10 to-accent/10"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <h2 className="text-3xl md:text-4xl font-bold mb-6">Ready to Revolutionize Your Financial Operations?</h2>
            <p className="text-lg text-foreground/80 mb-8 max-w-2xl mx-auto">
              Schedule a consultation with our Fintech experts to discuss how our solutions can transform your financial
              processes.
            </p>
            <Link
              href="/contact"
              className="px-8 py-3 rounded-full bg-gradient-to-r from-primary via-secondary to-accent text-white font-medium hover:shadow-lg transition-all text-lg inline-block"
            >
              Get Started Today
            </Link>
          </div>
        </div>
      </section>
    </>
  )
}

