import Image from "next/image"
import Link from "next/link"
import { ArrowRight, Users, TrendingUp, Lightbulb, Target, BarChart4, Briefcase } from "lucide-react"

export default function ConsultancyServicesPage() {
  return (
    <>
      {/* Hero Section */}
      <section className="pt-32 pb-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(147,51,234,0.15),transparent_40%)]"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-3xl">
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold mb-6">
              Strategic <span className="gradient-text">Consultancy</span> for Business Growth
            </h1>
            <p className="text-xl text-foreground/80 mb-8 max-w-2xl">
              Expert guidance to navigate complex challenges, optimize operations, and drive sustainable business
              growth.
            </p>
            <Link
              href="/contact"
              className="px-6 py-3 rounded-full bg-gradient-to-r from-primary via-secondary to-accent text-white font-medium hover:shadow-lg transition-all inline-flex items-center"
            >
              Get Started <ArrowRight className="ml-2 h-5 w-5" />
            </Link>
          </div>
        </div>
      </section>

      {/* Services Grid */}
      <section className="py-20 bg-background">
        <div className="container mx-auto px-4">
          <div className="text-center max-w-3xl mx-auto mb-16">
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Our Consultancy Services</h2>
            <p className="text-lg text-foreground/80">
              Comprehensive business consultancy solutions tailored to your specific needs and goals
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {/* Strategic Planning */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-accent/10 flex items-center justify-center mb-6 group-hover:bg-accent/20 transition-colors">
                <Target className="h-7 w-7 text-accent" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Strategic Planning</h3>
              <p className="text-foreground/70 mb-4">
                Develop comprehensive business strategies aligned with your vision, mission, and long-term objectives.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Vision & Mission Development
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Market Positioning
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Growth Strategy
                </li>
              </ul>
              <Link
                href="/services/consultancy/strategic-planning"
                className="inline-flex items-center text-accent hover:text-accent/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Business Transformation */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-primary/10 flex items-center justify-center mb-6 group-hover:bg-primary/20 transition-colors">
                <TrendingUp className="h-7 w-7 text-primary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Business Transformation</h3>
              <p className="text-foreground/70 mb-4">
                Navigate organizational change and digital transformation to stay competitive in evolving markets.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Digital Transformation
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Change Management
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Process Optimization
                </li>
              </ul>
              <Link
                href="/services/consultancy/business-transformation"
                className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Innovation Consulting */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-secondary/10 flex items-center justify-center mb-6 group-hover:bg-secondary/20 transition-colors">
                <Lightbulb className="h-7 w-7 text-secondary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Innovation Consulting</h3>
              <p className="text-foreground/70 mb-4">
                Foster a culture of innovation and develop new products, services, and business models.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Innovation Strategy
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Design Thinking
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Product Development
                </li>
              </ul>
              <Link
                href="/services/consultancy/innovation"
                className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Organizational Development */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-accent/10 flex items-center justify-center mb-6 group-hover:bg-accent/20 transition-colors">
                <Users className="h-7 w-7 text-accent" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Organizational Development</h3>
              <p className="text-foreground/70 mb-4">
                Build high-performing teams and create organizational structures that drive efficiency and growth.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Talent Management
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Leadership Development
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Organizational Design
                </li>
              </ul>
              <Link
                href="/services/consultancy/organizational-development"
                className="inline-flex items-center text-accent hover:text-accent/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Performance Improvement */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-primary/10 flex items-center justify-center mb-6 group-hover:bg-primary/20 transition-colors">
                <BarChart4 className="h-7 w-7 text-primary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Performance Improvement</h3>
              <p className="text-foreground/70 mb-4">
                Optimize business operations and enhance performance through data-driven insights and best practices.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Operational Excellence
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Cost Optimization
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Quality Management
                </li>
              </ul>
              <Link
                href="/services/consultancy/performance-improvement"
                className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Market Entry & Expansion */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-secondary/10 flex items-center justify-center mb-6 group-hover:bg-secondary/20 transition-colors">
                <Briefcase className="h-7 w-7 text-secondary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Market Entry & Expansion</h3>
              <p className="text-foreground/70 mb-4">
                Develop and execute strategies for entering new markets or expanding your business globally.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Market Research
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Go-to-Market Strategy
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  International Expansion
                </li>
              </ul>
              <Link
                href="/services/consultancy/market-expansion"
                className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>
          </div>
        </div>
      </section>

      {/* Case Study Section */}
      <section className="py-20 bg-gradient-to-b from-background to-background/95">
        <div className="container mx-auto px-4">
          <div className="text-center max-w-3xl mx-auto mb-16">
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Success Stories</h2>
            <p className="text-lg text-foreground/80">
              See how our consultancy services have transformed businesses across industries
            </p>
          </div>

          <div className="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=800"
                  alt="Business Transformation Case Study"
                  fill
                  className="object-cover"
                />
              </div>
              <div className="p-6">
                <div className="inline-block px-3 py-1 rounded-full bg-primary/10 text-primary text-sm font-medium mb-4">
                  Business Transformation
                </div>
                <h3 className="text-xl font-semibold mb-3">Digital Transformation Journey</h3>
                <p className="text-foreground/70 mb-4">
                  How we helped a traditional manufacturer embrace digital technologies and increase operational
                  efficiency by 45%.
                </p>
                <Link
                  href="/case-studies/digital-transformation"
                  className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>

            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=800"
                  alt="Market Expansion Case Study"
                  fill
                  className="object-cover"
                />
              </div>
              <div className="p-6">
                <div className="inline-block px-3 py-1 rounded-full bg-secondary/10 text-secondary text-sm font-medium mb-4">
                  Market Expansion
                </div>
                <h3 className="text-xl font-semibold mb-3">Global Market Entry Strategy</h3>
                <p className="text-foreground/70 mb-4">
                  How our consultancy helped a regional business successfully expand into international markets and grow
                  revenue by 120%.
                </p>
                <Link
                  href="/case-studies/market-expansion"
                  className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>
          </div>

          <div className="text-center mt-12">
            <Link
              href="/case-studies"
              className="px-6 py-2.5 rounded-full border border-border hover:border-accent hover:text-accent transition-all inline-flex items-center"
            >
              View all case studies <ArrowRight className="ml-2 h-4 w-4" />
            </Link>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-r from-primary/10 via-secondary/10 to-accent/10"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <h2 className="text-3xl md:text-4xl font-bold mb-6">Ready to Transform Your Business?</h2>
            <p className="text-lg text-foreground/80 mb-8 max-w-2xl mx-auto">
              Schedule a consultation with our expert consultants to discuss how we can help you achieve your business
              goals.
            </p>
            <Link
              href="/contact"
              className="px-8 py-3 rounded-full bg-gradient-to-r from-primary via-secondary to-accent text-white font-medium hover:shadow-lg transition-all text-lg inline-block"
            >
              Get Started Today
            </Link>
          </div>
        </div>
      </section>
    </>
  )
}

