import Image from "next/image"
import Link from "next/link"
import { ArrowRight, Brain, Bot, Database, LineChart, Zap, Shield } from "lucide-react"

export default function AIServicesPage() {
  return (
    <>
      {/* Hero Section */}
      <section className="pt-32 pb-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(67,56,202,0.15),transparent_40%)]"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-3xl">
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold mb-6">
              AI Solutions for <span className="gradient-text">Tomorrow's Challenges</span>
            </h1>
            <p className="text-xl text-foreground/80 mb-8 max-w-2xl">
              Harness the power of artificial intelligence to transform your business operations, gain valuable
              insights, and drive innovation.
            </p>
            <Link
              href="/contact"
              className="px-6 py-3 rounded-full bg-gradient-to-r from-primary via-secondary to-accent text-white font-medium hover:shadow-lg transition-all inline-flex items-center"
            >
              Get Started <ArrowRight className="ml-2 h-5 w-5" />
            </Link>
          </div>
        </div>
      </section>

      {/* Services Grid */}
      <section className="py-20 bg-background">
        <div className="container mx-auto px-4">
          <div className="text-center max-w-3xl mx-auto mb-16">
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Our AI Services</h2>
            <p className="text-lg text-foreground/80">
              Comprehensive AI solutions tailored to meet the evolving needs of modern businesses
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {/* Machine Learning */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-primary/10 flex items-center justify-center mb-6 group-hover:bg-primary/20 transition-colors">
                <Brain className="h-7 w-7 text-primary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Machine Learning</h3>
              <p className="text-foreground/70 mb-4">
                Develop predictive models and algorithms that learn from data to improve decision-making and automate
                processes.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Predictive Analytics
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Pattern Recognition
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Anomaly Detection
                </li>
              </ul>
              <Link
                href="/services/ai/machine-learning"
                className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Conversational AI */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-secondary/10 flex items-center justify-center mb-6 group-hover:bg-secondary/20 transition-colors">
                <Bot className="h-7 w-7 text-secondary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Conversational AI</h3>
              <p className="text-foreground/70 mb-4">
                Build intelligent chatbots and virtual assistants that understand natural language and provide
                personalized interactions.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Chatbots & Virtual Assistants
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Natural Language Processing
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Voice Recognition
                </li>
              </ul>
              <Link
                href="/services/ai/conversational-ai"
                className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Big Data Analytics */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-accent/10 flex items-center justify-center mb-6 group-hover:bg-accent/20 transition-colors">
                <Database className="h-7 w-7 text-accent" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Big Data Analytics</h3>
              <p className="text-foreground/70 mb-4">
                Extract valuable insights from large and complex datasets to drive strategic decision-making and
                identify opportunities.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Data Mining
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Real-time Analytics
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Business Intelligence
                </li>
              </ul>
              <Link
                href="/services/ai/big-data-analytics"
                className="inline-flex items-center text-accent hover:text-accent/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* Predictive Analytics */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-primary/10 flex items-center justify-center mb-6 group-hover:bg-primary/20 transition-colors">
                <LineChart className="h-7 w-7 text-primary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Predictive Analytics</h3>
              <p className="text-foreground/70 mb-4">
                Forecast trends, behaviors, and outcomes to make proactive decisions and stay ahead of market changes.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Demand Forecasting
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Risk Assessment
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-primary mr-2"></span>
                  Customer Behavior Analysis
                </li>
              </ul>
              <Link
                href="/services/ai/predictive-analytics"
                className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* AI Automation */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-secondary/10 flex items-center justify-center mb-6 group-hover:bg-secondary/20 transition-colors">
                <Zap className="h-7 w-7 text-secondary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">AI Automation</h3>
              <p className="text-foreground/70 mb-4">
                Streamline operations and reduce manual effort by automating repetitive tasks with intelligent AI
                systems.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Robotic Process Automation
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Workflow Optimization
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-secondary mr-2"></span>
                  Intelligent Document Processing
                </li>
              </ul>
              <Link
                href="/services/ai/automation"
                className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>

            {/* AI Security */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all group">
              <div className="w-14 h-14 rounded-lg bg-accent/10 flex items-center justify-center mb-6 group-hover:bg-accent/20 transition-colors">
                <Shield className="h-7 w-7 text-accent" />
              </div>
              <h3 className="text-xl font-semibold mb-3">AI Security</h3>
              <p className="text-foreground/70 mb-4">
                Protect your systems and data with AI-powered security solutions that detect and respond to threats in
                real-time.
              </p>
              <ul className="space-y-2 mb-6">
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Threat Detection
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Fraud Prevention
                </li>
                <li className="flex items-center text-foreground/70">
                  <span className="h-1.5 w-1.5 rounded-full bg-accent mr-2"></span>
                  Behavioral Analysis
                </li>
              </ul>
              <Link
                href="/services/ai/security"
                className="inline-flex items-center text-accent hover:text-accent/80 transition-colors"
              >
                Learn more <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>
          </div>
        </div>
      </section>

      {/* Case Study Section */}
      <section className="py-20 bg-gradient-to-b from-background to-background/95">
        <div className="container mx-auto px-4">
          <div className="text-center max-w-3xl mx-auto mb-16">
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Success Stories</h2>
            <p className="text-lg text-foreground/80">
              See how our AI solutions have transformed businesses across industries
            </p>
          </div>

          <div className="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=800"
                  alt="Financial Services AI Case Study"
                  fill
                  className="object-cover"
                />
              </div>
              <div className="p-6">
                <div className="inline-block px-3 py-1 rounded-full bg-primary/10 text-primary text-sm font-medium mb-4">
                  Financial Services
                </div>
                <h3 className="text-xl font-semibold mb-3">AI-Powered Fraud Detection System</h3>
                <p className="text-foreground/70 mb-4">
                  How a leading bank reduced fraud by 87% and saved $15M annually with our AI-powered detection system.
                </p>
                <Link
                  href="/case-studies/fraud-detection"
                  className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>

            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=800"
                  alt="Healthcare AI Case Study"
                  fill
                  className="object-cover"
                />
              </div>
              <div className="p-6">
                <div className="inline-block px-3 py-1 rounded-full bg-secondary/10 text-secondary text-sm font-medium mb-4">
                  Healthcare
                </div>
                <h3 className="text-xl font-semibold mb-3">Predictive Patient Care Platform</h3>
                <p className="text-foreground/70 mb-4">
                  How our AI solution helped a hospital network improve patient outcomes by 32% and reduce readmissions.
                </p>
                <Link
                  href="/case-studies/healthcare-prediction"
                  className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>
          </div>

          <div className="text-center mt-12">
            <Link
              href="/case-studies"
              className="px-6 py-2.5 rounded-full border border-border hover:border-primary hover:text-primary transition-all inline-flex items-center"
            >
              View all case studies <ArrowRight className="ml-2 h-4 w-4" />
            </Link>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-r from-primary/10 via-secondary/10 to-accent/10"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <h2 className="text-3xl md:text-4xl font-bold mb-6">Ready to Transform Your Business with AI?</h2>
            <p className="text-lg text-foreground/80 mb-8 max-w-2xl mx-auto">
              Schedule a consultation with our AI experts to discuss how our solutions can address your specific
              business challenges.
            </p>
            <Link
              href="/contact"
              className="px-8 py-3 rounded-full bg-gradient-to-r from-primary via-secondary to-accent text-white font-medium hover:shadow-lg transition-all text-lg inline-block"
            >
              Get Started Today
            </Link>
          </div>
        </div>
      </section>
    </>
  )
}

