import Image from "next/image"
import Link from "next/link"
import { ArrowRight } from "lucide-react"

export default function CaseStudiesPage() {
  return (
    <>
      {/* Hero Section */}
      <section className="pt-32 pb-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(67,56,202,0.15),transparent_40%)]"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-3xl">
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold mb-6">
              Our <span className="gradient-text">Success Stories</span>
            </h1>
            <p className="text-xl text-foreground/80 mb-8 max-w-2xl">
              Explore how Alpha3 Solution has helped businesses across industries transform and thrive with innovative
              technology solutions.
            </p>
          </div>
        </div>
      </section>

      {/* Filter Section */}
      <section className="py-8 border-b border-border">
        <div className="container mx-auto px-4">
          <div className="flex flex-wrap items-center justify-between gap-4">
            <div className="flex flex-wrap items-center gap-4">
              <span className="font-medium">Filter by:</span>
              <div className="flex flex-wrap gap-2">
                <button className="px-4 py-2 rounded-full bg-primary/10 text-primary text-sm font-medium">All</button>
                <button className="px-4 py-2 rounded-full bg-background border border-border text-sm font-medium hover:bg-muted/50 transition-colors">
                  AI Solutions
                </button>
                <button className="px-4 py-2 rounded-full bg-background border border-border text-sm font-medium hover:bg-muted/50 transition-colors">
                  Fintech
                </button>
                <button className="px-4 py-2 rounded-full bg-background border border-border text-sm font-medium hover:bg-muted/50 transition-colors">
                  Consultancy
                </button>
                <button className="px-4 py-2 rounded-full bg-background border border-border text-sm font-medium hover:bg-muted/50 transition-colors">
                  Technology
                </button>
              </div>
            </div>
            <div className="flex items-center gap-2">
              <span className="font-medium">Sort by:</span>
              <select className="px-4 py-2 rounded-lg bg-background border border-border text-sm font-medium focus:outline-none focus:ring-2 focus:ring-primary/50">
                <option>Most Recent</option>
                <option>Most Popular</option>
                <option>Industry</option>
              </select>
            </div>
          </div>
        </div>
      </section>

      {/* Case Studies Grid */}
      <section className="py-20 bg-background">
        <div className="container mx-auto px-4">
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {/* AI Case Study 1 */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all group">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=600"
                  alt="AI Fraud Detection Case Study"
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-300"
                />
              </div>
              <div className="p-6">
                <div className="flex justify-between items-start mb-4">
                  <div className="inline-block px-3 py-1 rounded-full bg-primary/10 text-primary text-sm font-medium">
                    AI Solutions
                  </div>
                  <span className="text-sm text-foreground/60">Financial Services</span>
                </div>
                <h3 className="text-xl font-semibold mb-3">AI-Powered Fraud Detection System</h3>
                <p className="text-foreground/70 mb-4">
                  How a leading bank reduced fraud by 87% and saved $15M annually with our AI-powered detection system.
                </p>
                <Link
                  href="/case-studies/fraud-detection"
                  className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>

            {/* Healthcare Case Study */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all group">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=600"
                  alt="Healthcare AI Case Study"
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-300"
                />
              </div>
              <div className="p-6">
                <div className="flex justify-between items-start mb-4">
                  <div className="inline-block px-3 py-1 rounded-full bg-primary/10 text-primary text-sm font-medium">
                    AI Solutions
                  </div>
                  <span className="text-sm text-foreground/60">Healthcare</span>
                </div>
                <h3 className="text-xl font-semibold mb-3">Predictive Patient Care Platform</h3>
                <p className="text-foreground/70 mb-4">
                  How our AI solution helped a hospital network improve patient outcomes by 32% and reduce readmissions.
                </p>
                <Link
                  href="/case-studies/healthcare-prediction"
                  className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>

            {/* Digital Banking Case Study */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all group">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=600"
                  alt="Digital Banking Case Study"
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-300"
                />
              </div>
              <div className="p-6">
                <div className="flex justify-between items-start mb-4">
                  <div className="inline-block px-3 py-1 rounded-full bg-secondary/10 text-secondary text-sm font-medium">
                    Fintech
                  </div>
                  <span className="text-sm text-foreground/60">Banking</span>
                </div>
                <h3 className="text-xl font-semibold mb-3">Next-Gen Mobile Banking Platform</h3>
                <p className="text-foreground/70 mb-4">
                  How we helped a traditional bank transform their digital presence and increase mobile engagement by
                  215%.
                </p>
                <Link
                  href="/case-studies/mobile-banking"
                  className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>

            {/* Payment Processing Case Study */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all group">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=600"
                  alt="Payment Processing Case Study"
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-300"
                />
              </div>
              <div className="p-6">
                <div className="flex justify-between items-start mb-4">
                  <div className="inline-block px-3 py-1 rounded-full bg-secondary/10 text-secondary text-sm font-medium">
                    Fintech
                  </div>
                  <span className="text-sm text-foreground/60">E-commerce</span>
                </div>
                <h3 className="text-xl font-semibold mb-3">Global Payment Infrastructure</h3>
                <p className="text-foreground/70 mb-4">
                  How our payment solution helped an e-commerce platform reduce transaction costs by 32% and expand
                  globally.
                </p>
                <Link
                  href="/case-studies/global-payments"
                  className="inline-flex items-center text-secondary hover:text-secondary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>

            {/* Business Transformation Case Study */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all group">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=600"
                  alt="Business Transformation Case Study"
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-300"
                />
              </div>
              <div className="p-6">
                <div className="flex justify-between items-start mb-4">
                  <div className="inline-block px-3 py-1 rounded-full bg-accent/10 text-accent text-sm font-medium">
                    Consultancy
                  </div>
                  <span className="text-sm text-foreground/60">Manufacturing</span>
                </div>
                <h3 className="text-xl font-semibold mb-3">Digital Transformation Journey</h3>
                <p className="text-foreground/70 mb-4">
                  How we helped a traditional manufacturer embrace digital technologies and increase operational
                  efficiency by 45%.
                </p>
                <Link
                  href="/case-studies/digital-transformation"
                  className="inline-flex items-center text-accent hover:text-accent/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>

            {/* Market Expansion Case Study */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all group">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=600"
                  alt="Market Expansion Case Study"
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-300"
                />
              </div>
              <div className="p-6">
                <div className="flex justify-between items-start mb-4">
                  <div className="inline-block px-3 py-1 rounded-full bg-accent/10 text-accent text-sm font-medium">
                    Consultancy
                  </div>
                  <span className="text-sm text-foreground/60">Retail</span>
                </div>
                <h3 className="text-xl font-semibold mb-3">Global Market Entry Strategy</h3>
                <p className="text-foreground/70 mb-4">
                  How our consultancy helped a regional business successfully expand into international markets and grow
                  revenue by 120%.
                </p>
                <Link
                  href="/case-studies/market-expansion"
                  className="inline-flex items-center text-accent hover:text-accent/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>

            {/* E-commerce Platform Case Study */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all group">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=600"
                  alt="E-commerce Platform Case Study"
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-300"
                />
              </div>
              <div className="p-6">
                <div className="flex justify-between items-start mb-4">
                  <div className="inline-block px-3 py-1 rounded-full bg-primary/10 text-primary text-sm font-medium">
                    Technology
                  </div>
                  <span className="text-sm text-foreground/60">Retail</span>
                </div>
                <h3 className="text-xl font-semibold mb-3">E-commerce Platform Overhaul</h3>
                <p className="text-foreground/70 mb-4">
                  How we helped a retailer increase online sales by 200% with a modern, high-performance e-commerce
                  platform.
                </p>
                <Link
                  href="/case-studies/ecommerce-platform"
                  className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>

            {/* Cloud Migration Case Study */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all group">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=600"
                  alt="Cloud Migration Case Study"
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-300"
                />
              </div>
              <div className="p-6">
                <div className="flex justify-between items-start mb-4">
                  <div className="inline-block px-3 py-1 rounded-full bg-primary/10 text-primary text-sm font-medium">
                    Technology
                  </div>
                  <span className="text-sm text-foreground/60">Manufacturing</span>
                </div>
                <h3 className="text-xl font-semibold mb-3">Enterprise Cloud Migration</h3>
                <p className="text-foreground/70 mb-4">
                  How our cloud migration strategy helped a manufacturing company reduce IT costs by 40% and improve
                  scalability.
                </p>
                <Link
                  href="/case-studies/cloud-migration"
                  className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>

            {/* Supply Chain Case Study */}
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all group">
              <div className="relative h-64">
                <Image
                  src="/placeholder.svg?height=400&width=600"
                  alt="Supply Chain Case Study"
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-300"
                />
              </div>
              <div className="p-6">
                <div className="flex justify-between items-start mb-4">
                  <div className="inline-block px-3 py-1 rounded-full bg-primary/10 text-primary text-sm font-medium">
                    AI Solutions
                  </div>
                  <span className="text-sm text-foreground/60">Logistics</span>
                </div>
                <h3 className="text-xl font-semibold mb-3">AI-Driven Supply Chain Optimization</h3>
                <p className="text-foreground/70 mb-4">
                  How our AI solution helped a logistics company optimize routes, reduce delivery times by 28%, and cut
                  fuel costs by 22%.
                </p>
                <Link
                  href="/case-studies/supply-chain"
                  className="inline-flex items-center text-primary hover:text-primary/80 transition-colors"
                >
                  Read case study <ArrowRight className="ml-2 h-4 w-4" />
                </Link>
              </div>
            </div>
          </div>

          {/* Pagination */}
          <div className="flex justify-center mt-12">
            <nav className="flex items-center space-x-2">
              <button className="w-10 h-10 rounded-md border border-border flex items-center justify-center hover:bg-muted/50 transition-colors">
                <span className="sr-only">Previous</span>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="20"
                  height="20"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-chevron-left"
                >
                  <path d="m15 18-6-6 6-6" />
                </svg>
              </button>
              <button className="w-10 h-10 rounded-md bg-primary text-white flex items-center justify-center">1</button>
              <button className="w-10 h-10 rounded-md border border-border flex items-center justify-center hover:bg-muted/50 transition-colors">
                2
              </button>
              <button className="w-10 h-10 rounded-md border border-border flex items-center justify-center hover:bg-muted/50 transition-colors">
                3
              </button>
              <span className="w-10 h-10 flex items-center justify-center">...</span>
              <button className="w-10 h-10 rounded-md border border-border flex items-center justify-center hover:bg-muted/50 transition-colors">
                8
              </button>
              <button className="w-10 h-10 rounded-md border border-border flex items-center justify-center hover:bg-muted/50 transition-colors">
                <span className="sr-only">Next</span>
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  width="20"
                  height="20"
                  viewBox="0 0 24 24"
                  fill="none"
                  stroke="currentColor"
                  strokeWidth="2"
                  strokeLinecap="round"
                  strokeLinejoin="round"
                  className="lucide lucide-chevron-right"
                >
                  <path d="m9 18 6-6-6-6" />
                </svg>
              </button>
            </nav>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-r from-primary/10 via-secondary/10 to-accent/10"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <h2 className="text-3xl md:text-4xl font-bold mb-6">Ready to Write Your Success Story?</h2>
            <p className="text-lg text-foreground/80 mb-8 max-w-2xl mx-auto">
              Partner with Alpha3 Solution to transform your business with cutting-edge technology and expert
              consultancy.
            </p>
            <Link
              href="/contact"
              className="px-8 py-3 rounded-full bg-gradient-to-r from-primary via-secondary to-accent text-white font-medium hover:shadow-lg transition-all text-lg inline-block"
            >
              Get Started Today
            </Link>
          </div>
        </div>
      </section>
    </>
  )
}

