import Image from "next/image"
import Link from "next/link"
import { ArrowRight, Search, Calendar, User } from "lucide-react"

export default function BlogPage() {
  return (
    <>
      {/* Hero Section */}
      <section className="pt-32 pb-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(67,56,202,0.15),transparent_40%)]"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-3xl mx-auto text-center">
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold mb-6">
              Insights & <span className="gradient-text">Innovations</span>
            </h1>
            <p className="text-xl text-foreground/80 mb-8 max-w-2xl mx-auto">
              Explore the latest trends, technologies, and strategies shaping the future of AI, Fintech, and digital
              transformation.
            </p>
            <div className="relative max-w-xl mx-auto">
              <input
                type="text"
                placeholder="Search articles..."
                className="w-full px-6 py-3 rounded-full bg-background border border-border focus:outline-none focus:ring-2 focus:ring-primary/50 pl-12"
              />
              <Search className="absolute left-4 top-1/2 transform -translate-y-1/2 text-foreground/60" />
            </div>
          </div>
        </div>
      </section>

      {/* Featured Article */}
      <section className="py-20 bg-background">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-12 text-center">Featured Article</h2>
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div className="relative h-96 rounded-xl overflow-hidden group">
              <Image
                src="/placeholder.svg?height=600&width=800"
                alt="Featured Article"
                fill
                className="object-cover transition-transform duration-300 group-hover:scale-105"
              />
            </div>
            <div>
              <div className="flex items-center gap-4 mb-4 text-sm text-foreground/60">
                <span className="flex items-center gap-1">
                  <Calendar className="w-4 h-4" />
                  May 15, 2025
                </span>
                <span className="flex items-center gap-1">
                  <User className="w-4 h-4" />
                  John Doe
                </span>
              </div>
              <h3 className="text-2xl font-bold mb-4">
                The Future of AI in Financial Services: Trends and Predictions
              </h3>
              <p className="text-foreground/80 mb-6">
                Artificial Intelligence is revolutionizing the financial services industry. From fraud detection to
                personalized banking experiences, AI is reshaping how financial institutions operate and serve their
                customers...
              </p>
              <Link
                href="/blog/ai-in-financial-services"
                className="inline-flex items-center text-primary hover:text-primary/80 transition-colors font-medium"
              >
                Read More <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
            </div>
          </div>
        </div>
      </section>

      {/* Recent Articles */}
      <section className="py-20 bg-muted/30">
        <div className="container mx-auto px-4">
          <h2 className="text-3xl font-bold mb-12 text-center">Recent Articles</h2>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {[1, 2, 3, 4, 5, 6].map((i) => (
              <div
                key={i}
                className="bg-background rounded-xl overflow-hidden shadow-lg hover:shadow-xl transition-shadow"
              >
                <div className="relative h-48">
                  <Image
                    src={`/placeholder.svg?height=300&width=400&text=Article+${i}`}
                    alt={`Article ${i}`}
                    fill
                    className="object-cover"
                  />
                </div>
                <div className="p-6">
                  <div className="flex items-center gap-4 mb-4 text-sm text-foreground/60">
                    <span className="flex items-center gap-1">
                      <Calendar className="w-4 h-4" />
                      May {10 + i}, 2025
                    </span>
                    <span className="flex items-center gap-1">
                      <User className="w-4 h-4" />
                      Author Name
                    </span>
                  </div>
                  <h3 className="text-xl font-bold mb-2">Blockchain Technology: Beyond Cryptocurrency</h3>
                  <p className="text-foreground/80 mb-4">
                    Exploring the diverse applications of blockchain technology across industries, from supply chain
                    management to digital identity verification...
                  </p>
                  <Link
                    href={`/blog/article-${i}`}
                    className="inline-flex items-center text-primary hover:text-primary/80 transition-colors font-medium"
                  >
                    Read More <ArrowRight className="ml-2 h-4 w-4" />
                  </Link>
                </div>
              </div>
            ))}
          </div>
          <div className="text-center mt-12">
            <Link
              href="/blog/archive"
              className="px-6 py-2.5 rounded-full border border-border hover:border-primary hover:text-primary transition-all inline-flex items-center"
            >
              View All Articles <ArrowRight className="ml-2 h-4 w-4" />
            </Link>
          </div>
        </div>
      </section>

      {/* Newsletter Section */}
      <section className="py-20 bg-gradient-to-r from-primary/10 via-secondary/10 to-accent/10">
        <div className="container mx-auto px-4">
          <div className="max-w-2xl mx-auto text-center">
            <h2 className="text-3xl font-bold mb-4">Stay Informed</h2>
            <p className="text-foreground/80 mb-8">
              Subscribe to our newsletter for the latest insights, trends, and innovations in AI, Fintech, and digital
              transformation.
            </p>
            <form className="flex flex-col sm:flex-row gap-4">
              <input
                type="email"
                placeholder="Enter your email"
                className="flex-grow px-6 py-3 rounded-full bg-background border border-border focus:outline-none focus:ring-2 focus:ring-primary/50"
              />
              <button
                type="submit"
                className="px-8 py-3 rounded-full bg-gradient-to-r from-primary via-secondary to-accent text-white font-medium hover:shadow-lg transition-all"
              >
                Subscribe
              </button>
            </form>
          </div>
        </div>
      </section>
    </>
  )
}

