import Image from "next/image"
import Link from "next/link"
import { CheckCircle2, Users, Award, Target, Lightbulb } from "lucide-react"

export default function AboutPage() {
  return (
    <>
      {/* Hero Section */}
      <section className="pt-32 pb-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-[radial-gradient(circle_at_30%_20%,rgba(67,56,202,0.15),transparent_40%)]"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-3xl">
            <h1 className="text-4xl md:text-5xl lg:text-6xl font-bold mb-6">
              About <span className="gradient-text">Alpha3 Solution</span>
            </h1>
            <p className="text-xl text-foreground/80 mb-8 max-w-2xl">
              We are a leading provider of AI, Fintech, Consultancy, and Technology services, dedicated to helping
              businesses thrive in the digital age.
            </p>
          </div>
        </div>
      </section>

      {/* Our Story Section */}
      <section className="py-20 bg-background">
        <div className="container mx-auto px-4">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
              <h2 className="text-3xl md:text-4xl font-bold mb-6">Our Story</h2>
              <p className="text-lg text-foreground/80 mb-6">
                Founded in 2015, Alpha3 Solution was born from a vision to bridge the gap between cutting-edge
                technology and practical business solutions. Our founders, a team of technology experts and business
                strategists, recognized that many organizations struggled to harness the power of emerging technologies
                effectively.
              </p>
              <p className="text-lg text-foreground/80 mb-6">
                What began as a small consultancy has grown into a global technology partner trusted by businesses of
                all sizes, from startups to Fortune 500 companies. Our journey has been defined by continuous
                innovation, unwavering commitment to excellence, and a deep understanding of our clients' evolving
                needs.
              </p>
              <p className="text-lg text-foreground/80">
                Today, Alpha3 Solution stands at the forefront of digital transformation, helping organizations navigate
                complex challenges and capitalize on new opportunities in an increasingly connected world.
              </p>
            </div>
            <div className="relative">
              <div className="relative z-10 rounded-2xl overflow-hidden shadow-xl">
                <Image
                  src="/placeholder.svg?height=600&width=800"
                  alt="Alpha3 Solution Team"
                  width={800}
                  height={600}
                  className="w-full h-auto object-cover"
                />
              </div>
              <div className="absolute -bottom-6 -right-6 w-64 h-64 bg-gradient-to-br from-primary to-accent rounded-full opacity-20 blur-3xl -z-10"></div>
              <div className="absolute -top-6 -left-6 w-64 h-64 bg-gradient-to-br from-secondary to-primary rounded-full opacity-20 blur-3xl -z-10"></div>
            </div>
          </div>
        </div>
      </section>

      {/* Mission & Vision Section */}
      <section className="py-20 bg-gradient-to-b from-background to-background/95">
        <div className="container mx-auto px-4">
          <div className="text-center max-w-3xl mx-auto mb-16">
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Our Mission & Vision</h2>
            <p className="text-lg text-foreground/80">Guided by clear purpose and forward-thinking vision</p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 gap-8">
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-8 hover:shadow-lg transition-all">
              <div className="w-14 h-14 rounded-lg bg-primary/10 flex items-center justify-center mb-6">
                <Target className="h-7 w-7 text-primary" />
              </div>
              <h3 className="text-2xl font-semibold mb-4">Our Mission</h3>
              <p className="text-foreground/80 mb-4">
                To empower organizations with innovative technology solutions that drive growth, efficiency, and
                competitive advantage. We are committed to delivering exceptional value through our expertise in AI,
                Fintech, Consultancy, and Technology services.
              </p>
              <p className="text-foreground/80">
                We believe in building long-term partnerships with our clients, understanding their unique challenges,
                and developing tailored solutions that exceed expectations.
              </p>
            </div>

            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-8 hover:shadow-lg transition-all">
              <div className="w-14 h-14 rounded-lg bg-secondary/10 flex items-center justify-center mb-6">
                <Lightbulb className="h-7 w-7 text-secondary" />
              </div>
              <h3 className="text-2xl font-semibold mb-4">Our Vision</h3>
              <p className="text-foreground/80 mb-4">
                To be the global leader in digital transformation, recognized for our innovation, expertise, and
                commitment to client success. We envision a world where technology seamlessly integrates with business
                processes, creating unprecedented opportunities for growth and impact.
              </p>
              <p className="text-foreground/80">
                We strive to stay at the forefront of technological advancement, continuously evolving our capabilities
                to address the emerging needs of businesses in an ever-changing digital landscape.
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Core Values Section */}
      <section className="py-20 bg-background">
        <div className="container mx-auto px-4">
          <div className="text-center max-w-3xl mx-auto mb-16">
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Our Core Values</h2>
            <p className="text-lg text-foreground/80">The principles that guide everything we do</p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all">
              <div className="w-14 h-14 rounded-lg bg-primary/10 flex items-center justify-center mb-6">
                <Award className="h-7 w-7 text-primary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Excellence</h3>
              <p className="text-foreground/70">
                We are committed to delivering the highest quality in everything we do. We set ambitious standards and
                continuously strive to exceed them.
              </p>
            </div>

            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all">
              <div className="w-14 h-14 rounded-lg bg-secondary/10 flex items-center justify-center mb-6">
                <Lightbulb className="h-7 w-7 text-secondary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Innovation</h3>
              <p className="text-foreground/70">
                We embrace creativity and forward-thinking. We constantly explore new ideas and technologies to solve
                complex problems and create value.
              </p>
            </div>

            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all">
              <div className="w-14 h-14 rounded-lg bg-accent/10 flex items-center justify-center mb-6">
                <Users className="h-7 w-7 text-accent" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Collaboration</h3>
              <p className="text-foreground/70">
                We believe in the power of teamwork. We foster an environment of open communication, mutual respect, and
                shared success.
              </p>
            </div>

            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl p-6 hover:shadow-lg transition-all">
              <div className="w-14 h-14 rounded-lg bg-primary/10 flex items-center justify-center mb-6">
                <CheckCircle2 className="h-7 w-7 text-primary" />
              </div>
              <h3 className="text-xl font-semibold mb-3">Integrity</h3>
              <p className="text-foreground/70">
                We conduct business with honesty, transparency, and ethical standards. We build trust through
                accountability and keeping our promises.
              </p>
            </div>
          </div>
        </div>
      </section>

      {/* Leadership Team Section */}
      <section className="py-20 bg-gradient-to-b from-background to-background/95">
        <div className="container mx-auto px-4">
          <div className="text-center max-w-3xl mx-auto mb-16">
            <h2 className="text-3xl md:text-4xl font-bold mb-4">Our Leadership Team</h2>
            <p className="text-lg text-foreground/80">
              Meet the experts driving innovation and excellence at Alpha3 Solution
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all">
              <div className="relative h-80">
                <Image src="/placeholder.svg?height=400&width=300" alt="CEO Portrait" fill className="object-cover" />
              </div>
              <div className="p-6">
                <h3 className="text-xl font-semibold mb-1">Sarah Johnson</h3>
                <p className="text-secondary mb-4">Chief Executive Officer</p>
                <p className="text-foreground/70 mb-4">
                  With over 20 years of experience in technology and business leadership, Sarah drives the strategic
                  vision and growth of Alpha3 Solution.
                </p>
                <div className="flex space-x-4">
                  <Link href="#" className="text-foreground/60 hover:text-primary transition-colors">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="20"
                      height="20"
                      viewBox="0 0 24 24"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      className="lucide lucide-linkedin"
                    >
                      <path d="M16 8a6 6 0 0 1 6 6v7h-4v-7a2 2 0 0 0-2-2 2 2 0 0 0-2 2v7h-4v-7a6 6 0 0 1 6-6z" />
                      <rect width="4" height="12" x="2" y="9" />
                      <circle cx="4" cy="4" r="2" />
                    </svg>
                  </Link>
                  <Link href="#" className="text-foreground/60 hover:text-primary transition-colors">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="20"
                      height="20"
                      viewBox="0 0 24 24"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      className="lucide lucide-twitter"
                    >
                      <path d="M22 4s-.7 2.1-2 3.4c1.6 10-9.4 17.3-18 11.6 2.2.1 4.4-.6 6-2C3 15.5.5 9.6 3 5c2.2 2.6 5.6 4.1 9 4-.9-4.2 4-6.6 7-3.8 1.1 0 3-1.2 3-1.2z" />
                    </svg>
                  </Link>
                </div>
              </div>
            </div>

            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all">
              <div className="relative h-80">
                <Image src="/placeholder.svg?height=400&width=300" alt="CTO Portrait" fill className="object-cover" />
              </div>
              <div className="p-6">
                <h3 className="text-xl font-semibold mb-1">Michael Chen</h3>
                <p className="text-primary mb-4">Chief Technology Officer</p>
                <p className="text-foreground/70 mb-4">
                  A visionary technologist with expertise in AI and emerging technologies, Michael leads our technical
                  strategy and innovation initiatives.
                </p>
                <div className="flex space-x-4">
                  <Link href="#" className="text-foreground/60 hover:text-primary transition-colors">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="20"
                      height="20"
                      viewBox="0 0 24 24"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      className="lucide lucide-linkedin"
                    >
                      <path d="M16 8a6 6 0 0 1 6 6v7h-4v-7a2 2 0 0 0-2-2 2 2 0 0 0-2 2v7h-4v-7a6 6 0 0 1 6-6z" />
                      <rect width="4" height="12" x="2" y="9" />
                      <circle cx="4" cy="4" r="2" />
                    </svg>
                  </Link>
                  <Link href="#" className="text-foreground/60 hover:text-primary transition-colors">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="20"
                      height="20"
                      viewBox="0 0 24 24"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      className="lucide lucide-twitter"
                    >
                      <path d="M22 4s-.7 2.1-2 3.4c1.6 10-9.4 17.3-18 11.6 2.2.1 4.4-.6 6-2C3 15.5.5 9.6 3 5c2.2 2.6 5.6 4.1 9 4-.9-4.2 4-6.6 7-3.8 1.1 0 3-1.2 3-1.2z" />
                    </svg>
                  </Link>
                </div>
              </div>
            </div>

            <div className="bg-background/50 backdrop-blur-sm border border-border rounded-xl overflow-hidden hover:shadow-lg transition-all">
              <div className="relative h-80">
                <Image src="/placeholder.svg?height=400&width=300" alt="CFO Portrait" fill className="object-cover" />
              </div>
              <div className="p-6">
                <h3 className="text-xl font-semibold mb-1">Olivia Rodriguez</h3>
                <p className="text-accent mb-4">Chief Financial Officer</p>
                <p className="text-foreground/70 mb-4">
                  With a background in fintech and strategic finance, Olivia ensures our financial health while driving
                  investment in innovation.
                </p>
                <div className="flex space-x-4">
                  <Link href="#" className="text-foreground/60 hover:text-primary transition-colors">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="20"
                      height="20"
                      viewBox="0 0 24 24"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      className="lucide lucide-linkedin"
                    >
                      <path d="M16 8a6 6 0 0 1 6 6v7h-4v-7a2 2 0 0 0-2-2 2 2 0 0 0-2 2v7h-4v-7a6 6 0 0 1 6-6z" />
                      <rect width="4" height="12" x="2" y="9" />
                      <circle cx="4" cy="4" r="2" />
                    </svg>
                  </Link>
                  <Link href="#" className="text-foreground/60 hover:text-primary transition-colors">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="20"
                      height="20"
                      viewBox="0 0 24 24"
                      fill="none"
                      stroke="currentColor"
                      strokeWidth="2"
                      strokeLinecap="round"
                      strokeLinejoin="round"
                      className="lucide lucide-twitter"
                    >
                      <path d="M22 4s-.7 2.1-2 3.4c1.6 10-9.4 17.3-18 11.6 2.2.1 4.4-.6 6-2C3 15.5.5 9.6 3 5c2.2 2.6 5.6 4.1 9 4-.9-4.2 4-6.6 7-3.8 1.1 0 3-1.2 3-1.2z" />
                    </svg>
                  </Link>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/* CTA Section */}
      <section className="py-20 relative overflow-hidden">
        <div className="absolute inset-0 bg-gradient-to-r from-primary/10 via-secondary/10 to-accent/10"></div>
        <div className="container mx-auto px-4 relative z-10">
          <div className="max-w-4xl mx-auto text-center">
            <h2 className="text-3xl md:text-4xl font-bold mb-6">Join Our Journey</h2>
            <p className="text-lg text-foreground/80 mb-8 max-w-2xl mx-auto">
              Partner with Alpha3 Solution to transform your business with cutting-edge technology and expert
              consultancy.
            </p>
            <Link
              href="/contact"
              className="px-8 py-3 rounded-full bg-gradient-to-r from-primary via-secondary to-accent text-white font-medium hover:shadow-lg transition-all text-lg inline-block"
            >
              Get in Touch
            </Link>
          </div>
        </div>
      </section>
    </>
  )
}

